getzero(N,[]) :- N<0,!.
getzero(0,[0]).
getzero(N,[0|R]) :- N>0, M is N-1, getzero(M,R).

normalize(x^0,[1]).
normalize(x,[0,1]).
normalize(x^N,Res) :- N>=1, M is N-1, getzero(M,R), append(R,[1],Res).
normalize(C,[C]) :- number(C).

normalize(A*B,M) :- normalize(A,Ap), normalize(B,Bp),
			multiply(Ap,Bp,M).
normalize(A+B,M) :- normalize(A,Ap), normalize(B,Bp),
			add(Ap,Bp,M).
normalize(A-B,M) :- normalize(A,Ap), normalize(B,Bp),
			subtract(Ap,Bp,M).
normalize(-A,M) :- normalize(A,Ap), negate(Ap,M).

add([],R,R).
add(R,[],R) :- R=[_|_].
add([X|Xr],[Y|Yr],[Z|Zr]):- Z is X+Y, add(Xr,Yr,Zr).


negate([],[]).
negate([X|R],[Mx|Mr]):- Mx is -X, negate(R,Mr).

subtract(X,Y,Z) :- negate(Y,My), add(X,My,Z).

msingle(_,[],[]).
msingle(X,[A|R],[Xa|Rx]) :- Xa is X*A, msingle(X,R,Rx).

multiply_n([],_,_,[]).
multiply_n([X|Xr],Y,D, Result) :- msingle(X,Y,Xy), getzero(D,Fill), 
	append(Fill,Xy,XyD), Dplus1 is D+1, multiply_n(Xr,Y,Dplus1,XrY), 
	add(XyD,XrY,Result).

multiply(A,B,R) :- multiply_n(A,B,-1,R).

normal_n([],_,In,In).
normal_n([0|Xr],N,In,Rr) :- !,M is N+1,normal_n(Xr,M,In,Rr).
normal_n([X|Xr],M,In,Rr) :- M =:= 0,!,sumterm(In,X,InX),normal_n(Xr,1,InX,Rr).
normal_n([X|Xr],M,In,Rr) :- M =:= 1,!,sumterm(In,X*x,InX),normal_n(Xr,2,InX,Rr).
normal_n([X|Xr],N,In,Rr) :- M is N+1, sumterm(In,X*x^N,InX), normal_n(Xr,M,InX,Rr).

sumterm(first,M*X,X) :- M =:= 1,!.
sumterm(first,M*X,-X) :- M =:= -1,!.
sumterm(first,X,X) :- !.
sumterm(In,M*X,In+X) :- M =:= 1,!.
sumterm(In,M*X,In-X) :- M =:= -1,!.
sumterm(In,M*X,In-N*X) :- M < 0, N is -M,!.
sumterm(In,X,In+X).

prettypoly(M,R) :- normal_n(M,0,first,R).

evalpoly(C,_,C) :- number(C).
evalpoly(x,Xval,Xval).
evalpoly(X+Y,Xval,Result) :- evalpoly(X,Xval,Xres), evalpoly(Y,Xval,Yres),
				Result is Xres+Yres.
evalpoly(X*Y,Xval,Result) :- evalpoly(X,Xval,Xres), evalpoly(Y,Xval,Yres),
				Result is Xres*Yres.
evalpoly(X-Y,Xval,Result) :- evalpoly(X,Xval,Xres), evalpoly(Y,Xval,Yres),
				Result is Xres-Yres.
evalpoly(X^Y,Xval,Result) :- evalpoly(X,Xval,Xres), Result is Xres^Y.
evalpoly(-X,Xval,Result) :- evalpoly(X,Xval,Xres), Result is -Xres.


remove0([],[]).
remove0([0|R],[]) :- allzero(R),!.
remove0([A|R],[A|Zr]) :- remove0(R,Zr).

allzero([]).
allzero([0|R]) :- allzero(R).
