{-- abstract data type example --}
--module Stack (Stack,empty,push,pop,show,(+))  where
module Stack where
	data Stack a = Empty | St [a] deriving Show
	empty = Empty
	push x Empty = St (x:[])
	push x (St st) = St (x:st)
	pop Empty = Nothing
	pop (St (x:rest)) = Just (x,St rest)
	tshow [] = "]"
	tshow [x] = show x ++ "]"
	tshow (x:rest@(_:_)) = show x ++ "," ++ tshow rest
	{--
	instance Show a => Show (Stack a) where
		show Empty = "|]"
		show (St a) = "|" ++ tshow a
	--}
	{--
	instance Num a => Num (Stack a) where
		(+) Empty (St a) = St a
		(+) (St []) (St a) = St a
		(+) (St (x:xr)) (St b) =  (St xr) + (push x (St b))
	--}
	len [] = 0
	len (_:r) = 1+len r


