symop(A) :- member(A,[+,*]).
asymop(A) :- member(A,[-,//]).

posteval([A],[],A).
posteval([A1,A2|AR],[O|R],V) :- isop(O), E =.. [O,A1,A2], 
			Eval is E, posteval([Eval|AR],R,V).
posteval(A,[T|R],V) :- number(T),posteval([T|A],R,V).


insert(X,Y,[X|Y]).
insert(X,[A|Y],[A|R]) :- insert(X,Y,R).

taketwo(H,T,Rr,[H|R]):- insert(T,Rr,R).
taketwo(A,B,R,[_|T]):- taketwo(A,B,R,T).

permut(_,[],0).
permut(X,[A|RestPerm],N) :- N>0,M is N-1,
		insert(A,Rest,X),permut(Rest,RestPerm,M).

% expgen([n1,n1,...], ntofind, listofops) 
% finds arithmetic operations to find V from the list of numbers
expgen([A|_],V,A) :- V is A.
expgen(L,V,T) :- taketwo(A,B,Br,L),
		symop(O), E =.. [O,A,B], 
		expgen([E|Br],V,T).
expgen(L,V,T) :- insert(A,Ar,L), insert(B,Br, Ar), 
		asymop(O), check(O,A,B), E =.. [O,A,B],
		expgen([E|Br],V,T).

check(-,A,B) :- A>B,!.
check(//,A,B) :- 0 is A mod B.

