ncurry f x y = f(x,y)

ncurry3 f x y z = f(x,y,z)

nmap f [] = []
nmap f (x:xs) = (f x):(nmap f xs)

nfilter f [] = []
nfilter f (x:xs) = if (f x) then (x:(nfilter f xs))
                  else (nfilter f xs)

reduce f s [] = s
reduce f s (x:xs) = f x (reduce f s xs)

nfoldr f [x,y] = f x y
nfoldr f (x:xs) = f x (nfoldr f xs)

nfoldl f [x,y] = f x y
nfoldl f (x:y:xs) = nfoldl f ((f x y):xs)

for m n incr f s = if (m>n) then s
                   else for (m+incr) n incr f (f m s)

iter 0 f s = s
iter n f s = iter (n-1) f (f s) 

fib n = let f (x,y) = (y,x+y)
            (a,b) = iter n f (0,1)
        in b

infix .<
f .< g =  let h x y z = g (f x y) z
          in h

infixr .>
f .> g = let h x y z = f x (g y z)
         in h

append [] y = y
append (x:xs) y = x:(append xs y)

rev1 [] =  []
rev1 (x:xs) = append (rev1 xs) [x]

rev2 l = let newrev [] xs = xs
             newrev (x:xs) y = newrev xs  (x:y)
         in newrev l [] 

sort _ [] = []
sort _ [x] = [x]
sort comp (x:xs) = let notcomp x y = not (comp x y)
		   in  (sort comp (nfilter (notcomp x) xs)) ++
			   (x : (sort comp (nfilter (comp x) xs)))

msort [] = []
msort (x:xs) = (msort (filter ((>) x) xs)) ++ (x: (msort (filter ((<=) x) xs)))
		
power n x | n<2 = x
          | otherwise = let p = power (div n 2)  x
	  		in p*p

{--
ncurry :: ((a,b) -> c) -> a -> b -> c
ncurry3 :: ((a,b,c) -> d) -> a -> b -> c -> d
nmap :: (a -> b) -> [a] -> [b]
nfilter :: (a -> Bool) -> [a] -> [a]
reduce :: (a -> b -> b) -> b -> [a] -> b
nfoldr :: (a -> a -> a) -> [a] -> a
nfoldl :: (a -> a -> a) -> [a] -> a
for :: (Ord a, Num a) => a -> a -> a -> (a -> b -> b) -> b -> b
iter :: Num a => a -> (b -> b) -> b -> b
fib :: (Num a, Num b) => a -> b
(.<) :: (a -> b -> c) -> (c -> d -> e) -> a -> b -> d -> e
(.>) :: (a -> b -> c) -> (d -> e -> b) -> a -> d -> e -> c
append :: [a] -> [a] -> [a]
rev1 :: [a] -> [a]
rev2 :: [a] -> [a]
sort :: (a -> a -> Bool) -> [a] -> [a]
--}

swap f x y = f y x

rreduce f s [] = s
rreduce f s (x:xs) = (rreduce f (f x s) xs)
