#include<iostream>
using namespace std;
char *colors[]={"BACKGROUND", "BLUE", "RED", "WHITE", "GREEN", "YELLOW", 
		"MAGENTA","ORANGE","PINK","NAVY"};

class Shape {
protected:
	int x,y;
	int color;
public:
	Shape(int a, int b, int c) { x=a; y=b; color=c;}
	virtual void draw(int)=0;
	void move(int nx,int ny) {
		draw(0);
		x=nx; y=ny;
		draw(color);
	}
};

class Square: public Shape {
	int width;
public:
	Square(int a, int b, int c, int w):Shape(a,b,c) { width=w;}
	void draw(int c) { cout << "lines(" << colors[c] <<
			",<" << x << ',' << y << ">,<" << x+ width << ',' <<
			y << ">,<" << x+width << ',' << y+width << ">,<" <<
			x << ',' << y+width << "><" << x << ',' << y << ">)\n";
		    }
};

class Circle: public Shape {
	int radius;
public:
	Circle(int a, int b, int c, int r):Shape(a,b,c) { radius=r;}
	void draw(int c) { cout << "circle(" << colors[c] << ",<" << x << 
				',' << y << ">," << radius << ")\n" ; }
};

class Rectangle: public Shape {
	int width,height;
public:
	Rectangle(int a, int b, int c, int w, int h):Shape(a,b,c) 
		{ width=w; height=h;}
	void draw(int c) { cout << "lines(" << colors[c] <<
			",<" << x << ',' << y << ">,<" << x+ width << ',' <<
			y << ">,<" << x+width << ',' << y+height << ">,<" <<
			x << ',' << y+height << "><" << x << ',' << y << ">)\n";
		    }
};

int main() {
	Square  s(10,10,1,5);
	Circle  c(20,20,2,6);
	Rectangle r(30,40,3,10,20);

	s.move(50,40);
	cout << "--\n";
	c.move(30,30);
	cout << "--\n";
	r.move(0,20);

	return 0;
}
