--module DS (DataStr,insert,get,isempty,Stack,Queue,HeapTree,emptystack,emptyqueue,emptyheap) where 
module DS  where 
class DataStr a where
    insert :: (Ord v) => (a v) -> v -> (a v)
    get :: (Ord v) => (a v)-> Maybe (v,(a v))
    isempty :: (Ord v) => (a v) -> Bool

instance  DataStr Stack where
    insert x v = push v x
    get x = pop x
    isempty (St []) = True
    isempty _ = False

    
data Stack a = St [a] deriving Show
push x (St st) = St (x:st)
pop (St []) = Nothing
pop (St (x:rest)) = Just (x, St rest)
emptystack=St []

{--
instance DataStr Queue where
    insert x v = enqueue v x
    get x = dequeue x
    isempty (Qu []) = True
    isempty _ = False

data Queue a = Qu [a] deriving Show
enqueue x (Qu st) = Qu (st ++ [x])
dequeue (Qu []) = Nothing
dequeue (Qu (x:rest)) = Just (x,Qu rest)
emptyqueue=Qu []


instance DataStr HeapTree  where
    insert x v = insertheap x v
    get EmptyH = Nothing
    get x = Just (popheap x)
    isempty EmptyH = True
    isempty _ = False
emptyheap=EmptyH


data HeapTree a = HeapLeaf (a,Int) | HeapNode (a,Int) (HeapTree a) (HeapTree a) | EmptyH

insertheap EmptyH x = HeapLeaf (x,1)
insertheap (HeapLeaf (a,n)) x = if a<x then HeapNode (a,n+1) (HeapLeaf (x,1)) EmptyH
			    else HeapNode (x,n+1) (HeapLeaf (a,1)) EmptyH
insertheap (HeapNode (a,n) left right) x = 
	let insertt n t b left right = 
		if (tsize left) < (tsize right) then
			HeapNode (t,n+1) (insertheap left b) right
		else
			HeapNode (t,n+1) left (insertheap right b) 
	    tsize EmptyH = 0
	    tsize (HeapLeaf _) = 1
	    tsize (HeapNode (_,n) _ _) = n
	in if a<x then insertt n a x left right
	   else insertt n x a left right

popheap (HeapLeaf (a,_))= (a,EmptyH)
popheap (HeapNode (a,n) EmptyH EmptyH) = (a,EmptyH)
popheap (HeapNode (a,n) left EmptyH) = 
	let (v,nt)=popheap left in (a,HeapNode (v,n-1) nt EmptyH)
popheap (HeapNode (a,n) EmptyH right) = 
	let (v,nt)=popheap right in (a,HeapNode (v,n-1) EmptyH nt)
popheap (HeapNode (a,n) left right) = 
	let topl=top left
	    topr=top right
	    top (HeapLeaf (a,_)) = a
	    top (HeapNode (a,_) _ _) = a
	in  if topl<topr then 
		(a,HeapNode (topl,n-1) (snd (popheap left)) right)
	    else
	    	(a,HeapNode (topr,n-1) left (snd (popheap right)))

		


instance Show a => Show (HeapTree a) where
        show t = showPre " " " " "==" t where
                        showPre _ _ inn EmptyH = inn ++ "- []\n"
                        showPre _ _ inn (HeapLeaf (x,_) ) = inn ++ "- " ++ (show x) ++ "\n"
                        showPre first second inn (HeapNode (a,_) lt rt) =
                                let newf = first ++ " |   "
                                    news = second ++ " |   "
                                    nullf = first ++ "     "
                                    nulls = second ++ "     "
                                    newinnf= first ++ " /----"
                                    newinns= second ++ " \\----"
                                in (showPre nullf newf newinnf rt) ++
                                        newf ++ "\n" ++
                                        inn ++ "+ " ++ (show a) ++ "\n" ++
                                        news ++ "\n" ++
                                        (showPre news nulls newinns lt)
--}
