#include<string.h>
#include<iostream>
using namespace std;
class Exception {
	char message[100];
public:
	Exception(const char a[]) { strncpy(message,a,100);}
	char *get() { return message;}
};

class OVERFLOW: public Exception {
public: OVERFLOW(const char a[]):Exception(a) {}	
};
class UNDERFLOW: public Exception {
public: UNDERFLOW(const char a[]):Exception(a) {}	
};
class NOTODD: public Exception {
public: NOTODD(const char a[]):Exception(a) {}	
};
class NOTPRIME: public Exception {
public: NOTPRIME(const char a[]):Exception(a) {}	
};

int isprime(int x)
{
	for (int i=2; i<=x/2 ; i++)
		if (x % i == 0) 
			return 0;
	return 1;
}

int f(int x) 
{ 
	if (x>1000) throw OVERFLOW("OF in f()");
	else if (x<0) throw UNDERFLOW("UF in f()");
	else if (x % 2==0) throw NOTODD("NO in f()");
	else if (isprime(x)) return x*x+x+1;
	else throw NOTPRIME("NP in f()");
}

int testf(int x)
{
	try {
		return f(x);
	} catch (NOTODD ex) {
		cerr  << "testf:Even number, trying n+1\n";
			return testf(x+1);
	} catch (NOTPRIME ex) {
		cerr << "testf: Prime number expected\n";
		throw ex;
	}
}

int tryit(int x)
{
	try {
		return isprime(testf(x));
	} catch (OVERFLOW ex) {
		cerr << "Should be < 1000\n";
		return 0;	
	} catch (UNDERFLOW ex) {
		 cerr << "Should be positive\n";
		 return 0;
	}
	return -1;
}

// factorial implementation without "return"
int factorial(int n)
{
	if (n <= 1) throw 1;
	else try {
		factorial(n-1);
	     } catch(int v) {
		throw n*v;
	    }
}

int main() {
	int x;

	cout << "Please enter an integer: ";
	cin >> x;
	cout << "Result is: " << tryit(x) << '\n';

	cout << "Please enter integer for factorial: ";
	cin >> x;
	try {
		factorial(x);
	} catch(int v) {
		cout << x << "! is: " << v << '\n';
	}

	return 0;
}
	



