module Btree(empty,insert,exists,delete)  where
--module Btree  where

data BinTree a = Leaf a | Node a (BinTree a) (BinTree a) | Empty

empty = Empty

insert Empty x = Leaf x
insert (Leaf a) x | x<a = Node a (Leaf x) Empty
                  | otherwise = Node a Empty (Leaf x)
insert (Node a left right) x | x<a = Node a (insert left x) right
                             | otherwise = Node a left (insert right x)

exists Empty _ = False
exists (Leaf a) x = x==a 
exists (Node a left right) x | x==a = True
			     | x<a = exists left x
                             | x>a = exists right x

delete Empty _ = Empty
delete (Leaf a) v | a==v = Empty
delete (Leaf a) v | otherwise = Leaf a
delete (Node a left right) v | v<a = Node a (delete left v) right
delete (Node a left right) v | v>a = Node a left (delete right v)
delete (Node a left right) v | otherwise =
		case left of
		Empty -> right
		a -> let (lm,lR)=maxandRest a
		     in Node lm lR right

maxandRest (Leaf a)            = (a,Empty)
maxandRest (Node a Empty Empty)= (a,Empty)
maxandRest (Node a left Empty) = 
	let (lm,lR)=maxandRest left
	in (a,Node lm lR Empty)
maxandRest (Node a left right) = 
	let (rm,rR)=maxandRest right
	in (rm,Node a left rR)


instance Show a => Show (BinTree a) where
        show t = showPre " " " " "==" t where
                        showPre _ _ inn Empty = inn ++ "- []\n"
                        showPre _ _ inn (Leaf x) = inn ++ "- " ++ (show x) ++ "\n"
                        showPre first second inn (Node a lt rt) =
                                let newf = first ++ " |   "
                                    news = second ++ " |   "
                                    nullf = first ++ "     "
                                    nulls = second ++ "     "
                                    newinnf= first ++ " /----"
                                    newinns= second ++ " \\----"
                                in (showPre nullf newf newinnf rt) ++
                                        newf ++ "\n" ++
                                        inn ++ "+ " ++ (show a) ++ "\n" ++
                                        news ++ "\n" ++
                                        (showPre news nulls newinns lt)
