/*
p( p(X,Y,Z) ) :- q(X) , r(Y), s(Z).

q( q(X,Y) ) :- r(X), r(Y) .
q( q2(X,Y) ) :- r(X), s(Y) .


r(a).
r(b).
r(c).

s(t).
s(u).
*/

% permuation v1:
% insert(X,Rest,List)  picks any member of list and Rest is the
% remaining list
insert(X,Y,[X|Y]).
insert(X,[A|Y],[A|R]) :- insert(X,Y,R).

% 0 permutation of any list is empty list
permut(_,[],0).
% pick any member of list X, take N-1 permutation of the remaining list,
% insert X to the begining of this N-1 permutation
permut(X,[A|RestPerm],N) :- N>0,M is N-1,
		insert(A,Rest,X),permut(Rest,RestPerm,M).


% permutation v2:
% an alternative
permut2(_,[],0).
% take first element out, take N-1 permutation of the rest,
% insert first element in all positions of the N-1 permutation
permut2([A|Rest],Perm, N):- N>0, M is N-1,
		permut2(Rest,RestPerm,M), insert(A,RestPerm,Perm).
% permutations without the first element. Take first out and calcualte 
% N permutations of the rest
permut2([_|Rest],Perm, N):- N>0, permut2(Rest,Perm,N).


% N combinations of a list
% 0 combination of all lists is []
combin(_,[],0).
% take first element out, find N-1 combinations of the rest
% insert first element to the result
combin([H|T],[H|R],N):- N>0,M is N-1, combin(T,R,M).
% combinations without the first element,
% calculate N combinations of the rest
combin([_|T],R,N):- N>0, combin(T,R,N).


member(X,[X|_]).
member(X,[_|R]) :- member(X,R).


concat([],X,X).
concat([X|R],T,[X|RandT]) :- concat(R,T,RandT).

reverse([],[]).
reverse([X|R],Reversed) :- reverse(R,RevR), concat(RevR,[X],Reversed).

% faster version accumulate the head element of the first list
% in the second recursively
reverse2([],X,X).
% X is acculmated in the second list and remaining list is
% called again. When first list is empty clause above is
% matched to propogate values in second list to result.
reverse2([X|R],Y,T) :- reverse2(R,[X|Y],T).

reversefast(X,Y) :- reverse2(X,[],Y).

% hint: how to show term display depth (instead of ...)
% set_prolog_flag(toplevel_printing_options,[quoted(true), portray(true), max_depth(200), attributes(portray)]). 
