{-- simple module example --}
module Mymath(myexp,myln,mysin,mycos,myarcsin) where
epsilon=1.0e-15
eps x = x> -epsilon && x<epsilon
maxiter=200000
converge func fs s m | m>maxiter = s  
		     | otherwise = if fs s then
					s
           	      		   else converge func fs (func s m) (m+1)


series f s x =  result where
		  (result,term,cx) = converge fstep epsstep (s,1.0,x) 1
	   	  fstep (a,b,x) n = let nb= b*(f x n)
				    in (a+nb,nb,x)
		  epsstep (a,b,c) = eps b

myexp = series fpar 1 where
                fpar x n = x / n

myln x = series (if x>=2 then fr else sfr) 0.0  x where
                fr x n | n==1 =  (x-1.0)/x
                       | otherwise =  (x-1.0)/x*(n-1)/n
		sfr x n | n==1 =  (x-1.0)
		        | otherwise = -(x-1.0)/n*(n-1.0)

mysin = series fs 0 where
		fs x n | n==1 = x
		fs x n | otherwise = -x*x/(2*n-2)/(2*n-1)

mycos x = mysin (x+pi/2)

myarcsin  = series fs 0 where
		fs x n | n==1 = x
		fs x n | otherwise = let k = n-1 
                                     in 2*k*(2*k-1)*(2*k-1)*x*x/(4*k*k*(2*k+1))
			
