#include<iostream>
using namespace std;
class Sortable {
public:
	virtual int lessthan(const Sortable *) = 0 ;
	virtual void swap(Sortable *)=0;
};
void sort(Sortable *p[],int n)
{
	int i,j;
	for (i=0;i<n-1;i++)
		for (j=i+1;j<n;j++) {
			if (! p[i]->lessthan(p[j]))
				p[i]->swap(p[j]);
		}
}
class Single : public Sortable {
	int x;
public:
	Single(int a) { x=a;}
	virtual int lessthan(const Sortable *q) {
		const Single *p=(const Single *)q;
		return (x<p->x);
	}
	virtual void swap(Sortable *q) {  int t; Single *p=(Single *)q; 
					   t= p->x; p->x=x; x=t;}
	void dump() { cout << x << ' ' ;}
};
class Complex : public Sortable {
	double x,y;
	double value() const { return x*x+y*y;} ;
public:
	Complex(double a,double b) { x=a;y=b; }
	virtual int lessthan(const Sortable *q) {
		const Complex *p=(const Complex *)q;
		return value() < p->value();
	}
	virtual void swap(Sortable *q) {  double t; Complex *p=(Complex *)q; 
					  t= p->x; p->x=x; x=t;
					  t= p->y; p->y=y; y=t;}
	void dump() { cout << '(' << x << ',' << y << ')' ;}
};


int main() {
	Single *values[10];
	int t[]={5,2,4,7,3,3,1,2,6,7};

	for (int i=0;i<10;i++)
		values[i]=new Single(t[i]);
	sort((Sortable **)values,10);
	for (int i=0;i<10;i++) { values[i]->dump(); cout << ' '; }
	cout << '\n';
	
	Complex *cvals[10];
	double u[]={5,2,4,7,3,3,1,2,6,7,0,0,2,0,2,5,6,2,3,9};

	for (int i=0;i<10;i++)
		cvals[i]=new Complex(u[i],u[10+i]);
	sort((Sortable **)cvals,10);
	for (int i=0;i<10;i++) { cvals[i]->dump(); cout << ' '; }
	cout << '\n';

	return 0;
}
