#include<iostream>
using namespace std;

class LinkedList {
	friend ostream & operator<<(ostream &,const LinkedList &);
	struct Node {
		int data;
		Node *next;
	} *root;           
	void freelist();
	void copy(const LinkedList&);
public:
	LinkedList();
	LinkedList(const LinkedList&);
	~LinkedList();
	void inserthead(int);	
	void insertsorted(int);
	void pophead();       
	int findanddel(int); 
	void operator=(const LinkedList &);
	int &operator[](int);
};


LinkedList::LinkedList() {
	root=NULL;
}

LinkedList::LinkedList(const LinkedList &s) {
	copy(s);
}

void LinkedList::freelist() {
	Node *p=root,*q;
	while (p!=NULL) {
		q=p;	
		p=p->next; 
		delete q;   
	}
}

LinkedList::~LinkedList() {
	freelist();
}

void LinkedList::inserthead(int a) {
	Node *p;
	p=new Node;                
	p->data=a;                  
	p->next=root;  
	root=p;               
}


void LinkedList::pophead() {
	Node *p=root;
	if (p != NULL) {             
		root=root->next; 
		delete p;                     
	} 
}



void LinkedList::insertsorted(int a) {
	Node *p=root,*q,*y;

	y=new Node;               

	y->data=a;                 

	while (p != NULL && (p->data < a))  {   
		q=p;                          
		p=p->next;                 
	}                                     
	
	y->next=p;    

	if (p==root)
		root=y;     
	else
		q->next=y;    
}



int LinkedList::findanddel(int a) {
	Node *p=root,*q;

	while (p != NULL && (p->data != a)) { 
		q=p;                        
		p=p->next;               
	}

	if (p==NULL)
		return 0;     
	else {		      
		q->next=p->next;    
		delete p;     
		return 1;     
	}
}

int & LinkedList::operator[](int a) {
	Node *p=root;
	int i=0;


	while (p != NULL && i<a) { 
		p=p->next;               
		i++;
	}
	if (p==NULL) 
		throw -1;
	else
		return p->data;
}




void LinkedList::copy(const LinkedList &s) {
     Node *p,*q,*newel;    

     p=s.root;              
     root = NULL;
     if (s.root != NULL) {
     	while ( p != NULL) {           
     		newel=new Node;          
		if (root == NULL) {   
			root = newel;  
			q = newel;          
		}
		q->next = newel;         
		newel->data = p->data;      
		p = p->next;            
		q = newel;                  
     	}
	q->next = NULL;           
    }
}

void LinkedList::operator=(const LinkedList &s) {
	freelist();
	copy(s);
}

ostream & operator<<(ostream &s,const LinkedList &l) {
	LinkedList::Node *p=l.root,*q;
	s << '(';
	while (p!=NULL) { 
		s << p->data;
		if (p->next != NULL) s << ',';
		p=p->next;
	}
	s << ")";
	return s;
}

int main() {
	LinkedList t,u;
	char w;

	
	cout << t << '\n';
	t.inserthead(3);
	t.inserthead(5);
	t.inserthead(8);
	cout << t << '\n';
	t.pophead();
	t.pophead();
	cout << t << '\n';
	t.insertsorted(2);
	t.insertsorted(9);
	t.insertsorted(4);
	t.insertsorted(3);
	t.insertsorted(7);
	t.insertsorted(14);
	t.insertsorted(1);
	cout << t << '\n';

	t.findanddel(3);
	t.findanddel(14);
	t.findanddel(7);
	cout << t << '\n';
	t.findanddel(33);
	cout << t << '\n';
	u=t;
	u.insertsorted(100);
	cout << "1----------\n";
	cout << t << '\n' << u << '\n';

	for (int i=0;i<6;i++) 
		cout << i << ':' << u[i] << ' ' ;
	cout << '\n';

	u[3]++;
	for (int i=0;i<6;i++) 
		cout << i << ':' << u[i] << ' ' ;
	cout << '\n';
	cout << "2----------\n";

	t.findanddel(2);
	t.findanddel(100);

	cout << t << '\n' << u << '\n';

	t=u	;
	cout << "3----------\n";
	cout << t << '\n';
	for (int i=0; i<100; i++) 
		t.insertsorted(i+50);

	cout << t << '\n';



	return 0;
}
