/*
 * Decompiled with CFR 0.152.
 */
package kmeans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import kmeans.AppletKM;
import kmeans.Cluster;
import kmeans.Data;
import kmeans.History;
import kmeans.Spot;
import kmeans.ascoltaInsSpot;

public class KM
extends Panel {
    private ArrayList array_Data;
    private ArrayList array_Cluster;
    private int steps;
    private History h;
    private MouseListener ml;
    private AppletKM applet;
    private int p;

    KM(AppletKM a) {
        this.applet = a;
        this.setBackground(Color.white);
        this.array_Data = new ArrayList();
        this.array_Cluster = new ArrayList();
        this.h = new History();
        this.ml = new ascoltaInsSpot(this);
        this.addMouseListener(this.ml);
        this.p = 2;
    }

    public void initSim(int numData, int numCluster) {
        this.steps = 0;
        this.setEnabled(true);
        this.h.clearHistory();
        this.removeAll();
        this.generateRandomCluster(numCluster);
        this.generateRandomData(numData);
        this.repaint();
    }

    public void startSim(int p) {
        this.p = p;
        this.setEnabled(false);
        this.joinToCluster();
        this.h.addArrayCluster(this.array_Cluster);
        this.repaint();
    }

    public boolean stepSim() {
        if (!this.checkStopCondition()) {
            ++this.steps;
            this.computeNewCentroids();
            this.joinToCluster();
            this.h.addArrayCluster(this.array_Cluster);
            this.repaint();
        }
        return this.checkStopCondition();
    }

    public void runSim() {
        while (!this.checkStopCondition()) {
            ++this.steps;
            this.computeNewCentroids();
            this.joinToCluster();
            this.h.addArrayCluster(this.array_Cluster);
        }
        this.repaint();
    }

    public void resetSim() {
        this.removeAllCluster();
        this.array_Cluster = this.h.getFirst(this);
        this.h.clearHistory();
        int i = 0;
        while (i < this.array_Data.size()) {
            Data d = (Data)this.array_Data.get(i);
            d.setColor(Color.black);
            ++i;
        }
        this.steps = 0;
        this.setEnabled(true);
        this.repaint();
    }

    public int getTotalSteps() {
        return this.steps;
    }

    public boolean isTerminated() {
        return this.checkStopCondition();
    }

    public void setShowHistory(boolean b) {
        this.h.setShowHistoryEnabled(b);
        this.repaint();
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.array_Data.size()) {
            Data d = (Data)this.array_Data.get(i);
            d.draw(g);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.array_Cluster.size()) {
            Cluster c = (Cluster)this.array_Cluster.get(i2);
            c.draw(g);
            ++i2;
        }
        this.h.drawHistory(g);
    }

    public void addDataSpot(int x, int y) {
        Data d = new Data(x, y);
        this.array_Data.add(d);
        this.add((Component)d, null);
        this.AutoCheckEnable();
        this.repaint();
    }

    public void addClusterSpot(int x, int y) {
        Cluster c = new Cluster(x, y);
        this.array_Cluster.add(c);
        this.add((Component)c, null);
        this.AutoCheckEnable();
        this.repaint();
    }

    public void deleteSpot(Spot s) {
        this.remove(s);
        ((AbstractCollection)this.array_Data).remove(s);
        ((AbstractCollection)this.array_Cluster).remove(s);
        this.AutoCheckEnable();
        this.repaint();
    }

    private void AutoCheckEnable() {
        if (!this.array_Cluster.isEmpty() && !this.array_Data.isEmpty()) {
            this.applet.button3_Start.setEnabled(true);
            this.applet.choice1_metric.setEnabled(true);
            this.applet.textField_p.setEnabled(true);
        } else {
            this.applet.button3_Start.setEnabled(false);
            this.applet.choice1_metric.setEnabled(false);
            this.applet.textField_p.setEnabled(false);
        }
        this.applet.textField1_Data.setText(Integer.toString(this.array_Data.size()));
        this.applet.textField2_Cluster.setText(Integer.toString(this.array_Cluster.size()));
    }

    private void generateRandomData(int amount) {
        this.array_Data.clear();
        int i = 0;
        while (i < amount) {
            int x = (int)(Math.random() * (double)this.getWidth());
            int y = (int)(Math.random() * (double)this.getHeight());
            Data d = new Data(x, y);
            this.array_Data.add(d);
            this.add((Component)d, null);
            ++i;
        }
    }

    private void generateRandomCluster(int amount) {
        this.array_Cluster.clear();
        int i = 0;
        while (i < amount) {
            int x = (int)(Math.random() * (double)this.getWidth());
            int y = (int)(Math.random() * (double)this.getHeight());
            Cluster c = new Cluster(x, y);
            this.array_Cluster.add(c);
            this.add((Component)c, null);
            ++i;
        }
    }

    private void computeNewCentroids() {
        int i = 0;
        while (i < this.array_Cluster.size()) {
            Cluster newC = (Cluster)this.array_Cluster.get(i);
            Point baricentro = this.averageOf(newC);
            newC.setSpot((int)baricentro.getX(), (int)baricentro.getY());
            ++i;
        }
    }

    private Point averageOf(Cluster cluster) {
        int counter = 0;
        int amountX = 0;
        int amountY = 0;
        int i = 0;
        while (i < this.array_Data.size()) {
            Data d = (Data)this.array_Data.get(i);
            if (d.getCluster() == cluster) {
                ++counter;
                amountX += d.getX();
                amountY += d.getY();
            }
            ++i;
        }
        Point punto = counter == 0 ? new Point(cluster.getX(), cluster.getY()) : new Point(Math.abs(amountX / counter), Math.abs(amountY / counter));
        return punto;
    }

    private void joinToCluster() {
        int i = 0;
        while (i < this.array_Data.size()) {
            Cluster c;
            int num_c = 0;
            double min_distance = Double.POSITIVE_INFINITY;
            Data d = (Data)this.array_Data.get(i);
            int j = 0;
            while (j < this.array_Cluster.size()) {
                c = (Cluster)this.array_Cluster.get(j);
                int dx = Math.abs(d.getX() - c.getX());
                int dy = Math.abs(d.getY() - c.getY());
                double current_distance = (dx ^ this.p) + (dy ^ this.p);
                if ((current_distance = Math.pow(current_distance, 1.0 / (double)this.p)) < min_distance) {
                    min_distance = current_distance;
                    num_c = j;
                }
                ++j;
            }
            c = (Cluster)this.array_Cluster.get(num_c);
            d.joinToCluster(c);
            d.setColor(c.getColor());
            ++i;
        }
    }

    private boolean checkStopCondition() {
        if (this.steps < 1) {
            return false;
        }
        if (this.steps > 200) {
            return true;
        }
        ArrayList array_p = this.h.getPrevious();
        double max = 0.0;
        int j = 0;
        while (j < this.array_Cluster.size()) {
            Cluster a = (Cluster)this.array_Cluster.get(j);
            Cluster b = (Cluster)array_p.get(j);
            double den = this.getWidth() ^ 2 + this.getHeight() ^ 2;
            int dx = a.getX() - b.getX();
            int dy = a.getY() - b.getY();
            double d = dx ^ 2 + dy ^ 2;
            max = Math.max(max, d / den);
            ++j;
        }
        return max < 0.01;
    }

    private void removeAllCluster() {
        int j = 0;
        while (j < this.array_Cluster.size()) {
            Cluster c = (Cluster)this.array_Cluster.get(j);
            this.remove(c);
            ++j;
        }
    }
}

