/*
 * Decompiled with CFR 0.152.
 */
package kmeans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import kmeans.ControllaMouse;
import kmeans.MouseDeleteSpot;

public abstract class Spot
extends Component {
    protected int x;
    protected int y;
    protected Color c;
    private boolean moveEnabled;
    private MouseMotionListener mml;
    private MouseListener ml;
    protected int semiDim = 5;

    Spot(int x, int y) {
        this.x = x;
        this.y = y;
        this.c = new Color(0, 0, 0);
        this.moveEnabled = true;
        this.setBounds(x - this.semiDim - 1, y - this.semiDim - 1, 2 * this.semiDim + 2, 2 * this.semiDim + 2);
        this.mml = new ControllaMouse(this);
        this.addMouseMotionListener(this.mml);
        this.ml = new MouseDeleteSpot(this);
        this.addMouseListener(this.ml);
    }

    Spot(int x, int y, Color c) {
        this.x = x;
        this.y = y;
        this.c = c;
        this.moveEnabled = true;
        this.setBounds(x - this.semiDim - 1, y - this.semiDim - 1, 2 * this.semiDim + 2, 2 * this.semiDim + 2);
        this.mml = new ControllaMouse(this);
        this.addMouseMotionListener(this.mml);
        this.ml = new MouseDeleteSpot(this);
        this.addMouseListener(this.ml);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setSpot(int x, int y) {
        this.x = x;
        this.y = y;
        this.setBounds(x - this.semiDim - 1, y - this.semiDim - 1, 2 * this.semiDim + 2, 2 * this.semiDim + 2);
    }

    public Color getColor() {
        return this.c;
    }

    public void setColor(Color c) {
        this.c = c;
    }

    public int getSemiDim() {
        return this.semiDim;
    }

    public abstract void draw(Graphics var1);
}

