/*
 * Decompiled with CFR 0.152.
 */
package kmeans;

import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import kmeans.Spot;

class ControllaMouse
extends MouseMotionAdapter {
    private Spot s;

    ControllaMouse(Spot s) {
        this.s = s;
    }

    public void mouseDragged(MouseEvent e) {
        Container c = this.s.getParent();
        int width = c.getWidth();
        int height = c.getHeight();
        int x = this.s.getX() + e.getX() - this.s.getSemiDim();
        int y = this.s.getY() + e.getY() - this.s.getSemiDim();
        if (x < width && x > 0 && y < height && y > 0) {
            this.s.setSpot(x, y);
        } else {
            x = Math.max(Math.min(x, width), 0);
            y = Math.max(Math.min(y, height), 0);
            if (x <= 0) {
                this.s.setSpot(1, y);
            }
            if (x >= width) {
                this.s.setSpot(width - 1, y);
            }
            if (y <= 0) {
                this.s.setSpot(x, 1);
            }
            if (y >= height) {
                this.s.setSpot(x, height - 1);
            }
        }
    }
}

