/*
 * Decompiled with CFR 0.152.
 */
package kmeans;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.util.ArrayList;
import kmeans.Cluster;

class History {
    private ArrayList array_history = new ArrayList();
    private boolean showHistoryEnabled = false;

    History() {
    }

    public void setShowHistoryEnabled(boolean b) {
        this.showHistoryEnabled = b;
    }

    public ArrayList getFirst(Container cont) {
        ArrayList<Cluster> array_c = new ArrayList<Cluster>();
        ArrayList array_first = (ArrayList)this.array_history.get(0);
        int i = 0;
        while (i < array_first.size()) {
            Cluster f = (Cluster)array_first.get(i);
            Cluster c = new Cluster(f.x, f.y, f.c);
            array_c.add(c);
            cont.add(c);
            ++i;
        }
        return array_c;
    }

    public ArrayList getPrevious() {
        ArrayList<Cluster> array_c = new ArrayList<Cluster>();
        int s = this.array_history.size();
        ArrayList array_prev = (ArrayList)this.array_history.get(s - 2);
        int i = 0;
        while (i < array_prev.size()) {
            Cluster f = (Cluster)array_prev.get(i);
            Cluster c = new Cluster(f.x, f.y, f.c);
            array_c.add(c);
            ++i;
        }
        return array_c;
    }

    public void addArrayCluster(ArrayList a) {
        ArrayList<Cluster> ha = new ArrayList<Cluster>();
        int i = 0;
        while (i < a.size()) {
            Cluster c = (Cluster)a.get(i);
            Cluster hc = new Cluster(c.getX(), c.getY(), c.getColor());
            ha.add(hc);
            ++i;
        }
        this.array_history.add(ha);
    }

    public void clearHistory() {
        this.array_history.clear();
    }

    public void drawHistory(Graphics g) {
        if (this.array_history.isEmpty() || !this.showHistoryEnabled) {
            return;
        }
        if (this.array_history.size() > 1) {
            int i = 1;
            while (i < this.array_history.size()) {
                ArrayList a = (ArrayList)this.array_history.get(i - 1);
                ArrayList b = (ArrayList)this.array_history.get(i);
                int j = 0;
                while (j < a.size()) {
                    Color originale;
                    Cluster ca = (Cluster)a.get(j);
                    Cluster cb = (Cluster)b.get(j);
                    g.drawLine(ca.getX(), ca.getY(), cb.getX(), cb.getY());
                    if (i == this.array_history.size() - 1) {
                        originale = cb.getColor();
                        cb.setColor(new Color(255, 255, 255));
                        cb.draw(g);
                        cb.setColor(originale);
                    }
                    if (i == 1) {
                        originale = ca.getColor();
                        ca.setColor(new Color(0, 0, 0));
                        ca.draw(g);
                        ca.setColor(originale);
                    }
                    if (i > 0 && i < this.array_history.size() - 1) {
                        cb.draw(g);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            ArrayList a = (ArrayList)this.array_history.get(0);
            int j = 0;
            while (j < a.size()) {
                Cluster ca = (Cluster)a.get(j);
                ca.draw(g);
                ++j;
            }
        }
    }
}

