
#include <gl\glut.h>
#include <gl\gl.h>
#include <gl\glu.h>
#include <stdio.h>

#include <math.h>

static int mainWindow;
static int h=600,w=600;

static int skipPushPop=0;
static int movex=0;

int cursorX,cursorY;

void draw();

void initScene(int argc, char **argv) {

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(-300,300,-300,300,-10,10);
	glMatrixMode(GL_MODELVIEW);
}


void drawSquare() {
	glColor3f(0.5f, 0.5f, 0.5f);
	glBegin(GL_QUADS);
		glVertex2f(0.5f, 0.5f);
		glVertex2f(-0.5f, 0.5f);
		glVertex2f(-0.5f, -0.5f);
		glVertex2f(0.5f, -0.5f);
	glEnd();
}

 
void drawCircle()
{
   float DEG2RAD = 3.14159/180;
   int i;

   glColor3f(1.0f, 0.0f, 0.0f);
   glBegin(GL_TRIANGLE_FAN);

      glVertex2f(0.0f,0.0f); 
      for (i=0; i < 360; i++)
      {
         float degInRad = i*DEG2RAD;
         glVertex2f(cos(degInRad),sin(degInRad));
      }
 
   glEnd();
}

void drawLine()
{
        glColor3f(0.0f, 1.0f, 0.0f);
	glBegin(GL_LINES);
		glVertex2f(0.0f,0.0f);
		glVertex2f(1.0f,0.0f);
	glEnd();
	
}

void drawTriangle()
{
        glColor3f(0.0f, 0.0f, 1.0f);
	glBegin(GL_TRIANGLES);
		glVertex2f(1.0f,0.0f);
		glVertex2f(0.0f,1.0f);
		glVertex2f(-1.0f,0.0f);
	glEnd();
}

void renderScene() {

	int i;

	glutSetWindow(mainWindow);  

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();

	/* global transformation to scale the bike and move it to the lowev left corner of the display window */
	glTranslatef(-100.0f+movex,-100.0f, 0.0f);
	glScalef(40.0f,40.0f,1.0f);


	/* draw front wheel */
	if (!skipPushPop) glPushMatrix();
	glTranslatef(1.0f,-0.5f,0.0f);
	glScalef(0.5f,0.5f,0.0f);
	drawCircle();
	if (!skipPushPop) glPopMatrix();

	/* draw back wheel */
	if (!skipPushPop) glPushMatrix();
	glTranslatef(-1.0f,-0.5f,0.0f);
	glScalef(0.5f,0.5f,0.0f);
	drawCircle();
	if (!skipPushPop) glPopMatrix();

	/* draw triangle frame */
	if (!skipPushPop) glPushMatrix();
	glTranslatef(0.0f,-0.5f,0.0f);
	drawTriangle();
	if (!skipPushPop) glPopMatrix();

	/* draw metal bar above triangle body */
	if (!skipPushPop) glPushMatrix();
	glTranslatef(-1.0f,0.5f,0.0f);
	glScalef(2.0f,0.0f,0.0f);
	drawLine();
	if (!skipPushPop) glPopMatrix();

	/* draw square seat centered at the metal bar to the left*/
	if (!skipPushPop) glPushMatrix();
	glTranslatef(-0.8f,0.5f,0.0f);
	glScalef(0.5f,0.5f,1.0f);
	drawSquare();
	if (!skipPushPop) glPopMatrix();

	/* draw the handle bars as a rotated line at the right end of the metal bar */
	if (!skipPushPop) glPushMatrix();
	glTranslatef(0.7f,0.25f,0.0f);
	glRotatef(45.0f,0.0,0.0,1.0);
	drawLine();
	if (!skipPushPop) glPopMatrix();

	glutSwapBuffers();
}



/*-------------------
Keyboard 
-------------------*/


void processKeys(unsigned char key, int x, int y) {
	
	if (key == 27) {
		exit(0);
	}
	else if (key == 'c')
	{
		skipPushPop = skipPushPop?0:1;
		glutPostRedisplay();
	}
	else if (key == 'r')
	{
		movex+=2;
		if (movex==400) movex=0;
		glutPostRedisplay();
	}
}



/*---------
Main
---------*/

int main(int argc, char **argv)
{

	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DEPTH  | GLUT_DOUBLE | GLUT_RGBA);
	glutInitWindowPosition(10,10);
	glutInitWindowSize(w,h);
	mainWindow = glutCreateWindow("PushMatrix-PopMatrix Example");

	glutKeyboardFunc(processKeys);
	glutDisplayFunc(renderScene);

	initScene(argc,argv);

	glutMainLoop();

	return(0);
}
